-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- مضيف: localhost:3306
-- وقت الجيل: 25 أكتوبر 2025 الساعة 13:00
-- إصدار الخادم: 11.4.8-MariaDB-cll-lve-log
-- نسخة PHP: 8.3.26

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- قاعدة بيانات: `supehgku_test0`
--

DELIMITER $$
--
-- الإجراءات
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `cleanup_expired_bans` ()   BEGIN
    DELETE FROM `limit_bans` 
    WHERE `banned_until` < NOW();
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `reset_expired_counters` ()   BEGIN
    UPDATE `limit_counters` 
    SET `day_used` = 0,
        `day_reset_at` = DATE_ADD(CURDATE(), INTERVAL 1 DAY)
    WHERE `day_reset_at` < NOW();
    
    UPDATE `limit_counters` 
    SET `week_used` = 0,
        `week_reset_at` = DATE_ADD(
            DATE_ADD(CURDATE(), INTERVAL (7 - WEEKDAY(CURDATE())) DAY),
            INTERVAL 1 WEEK
        )
    WHERE `week_reset_at` < NOW();
    
    UPDATE `limit_counters` 
    SET `month_used` = 0,
        `month_reset_at` = DATE_ADD(
            LAST_DAY(CURDATE()),
            INTERVAL 1 DAY
        )
    WHERE `month_reset_at` < NOW();
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- بنية الجدول `account_groups`
--

CREATE TABLE `account_groups` (
  `id` int(11) NOT NULL,
  `group_name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT 0 COMMENT 'المجموعة الافتراضية',
  `active` tinyint(1) DEFAULT 1,
  `locked` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'قفل المجموعة يمنع rename/delete',
  `priority` int(11) DEFAULT 0 COMMENT 'أولوية البحث',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `group_name_lower` varchar(64) GENERATED ALWAYS AS (lcase(`group_name`)) STORED
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='مجموعات الحسابات لتنظيم الوصول';

--
-- إرجاع أو استيراد بيانات الجدول `account_groups`
--

INSERT INTO `account_groups` (`id`, `group_name`, `description`, `is_default`, `active`, `locked`, `priority`, `created_at`) VALUES
(1, 'default', 'المجموعة العامة - تحتوي جميع الحسابات', 1, 1, 0, 0, '2025-10-22 19:51:06'),
(5, 'vippro', NULL, 0, 1, 0, 0, '2025-10-22 23:03:15'),
(6, 'vip', NULL, 0, 1, 0, 0, '2025-10-22 23:03:51');

-- --------------------------------------------------------

--
-- Stand-in structure for view `active_bans`
-- (See below for the actual view)
--
CREATE TABLE `active_bans` (
`id` bigint(20)
,`user_id` bigint(20)
,`account_id` int(11)
,`banned_until` timestamp
,`reason` varchar(255)
,`created_at` timestamp
,`account_name` varchar(64)
,`hours_remaining` bigint(21)
);

-- --------------------------------------------------------

--
-- بنية الجدول `allowed_users`
--

CREATE TABLE `allowed_users` (
  `id` bigint(20) NOT NULL,
  `bot_token` varchar(128) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `banned` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `allowed_users`
--

INSERT INTO `allowed_users` (`id`, `bot_token`, `user_id`, `banned`, `created_at`) VALUES
(276, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 0, '2025-10-22 20:37:44'),
(277, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 0, '2025-10-24 16:48:16'),
(278, '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', 5458195623, 0, '2025-10-24 17:02:45'),
(279, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 6914878734, 0, '2025-10-24 17:12:56'),
(280, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 6914878734, 0, '2025-10-24 17:32:49'),
(281, '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', 6914878734, 0, '2025-10-24 17:33:02');

-- --------------------------------------------------------

--
-- بنية الجدول `bot_groups`
--

CREATE TABLE `bot_groups` (
  `bot_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='ربط البوتات بالمجموعات';

--
-- إرجاع أو استيراد بيانات الجدول `bot_groups`
--

INSERT INTO `bot_groups` (`bot_id`, `group_id`, `created_at`) VALUES
(27, 1, '2025-10-23 20:27:41'),
(28, 1, '2025-10-24 16:48:05'),
(28, 6, '2025-10-24 16:53:13'),
(29, 1, '2025-10-24 17:02:33'),
(29, 6, '2025-10-24 17:07:38');

-- --------------------------------------------------------

--
-- بنية الجدول `bot_managers`
--

CREATE TABLE `bot_managers` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL COMMENT 'معرف المدير في Telegram',
  `bot_token` varchar(128) DEFAULT NULL COMMENT 'توكن بوت محدد أو NULL للكل',
  `permissions` text NOT NULL COMMENT 'الصلاحيات: 1,2,3 أو all',
  `username` varchar(64) DEFAULT NULL COMMENT 'اسم المستخدم للمدير',
  `added_by` bigint(20) NOT NULL COMMENT 'المالك الذي أضافه',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'نشط أو معطل',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='المدراء الفرعيون وصلاحياتهم';

--
-- إرجاع أو استيراد بيانات الجدول `bot_managers`
--

INSERT INTO `bot_managers` (`id`, `user_id`, `bot_token`, `permissions`, `username`, `added_by`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 5458195623, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 'all', NULL, 5458195623, 1, '2025-10-22 21:20:16', '2025-10-22 21:20:16');

-- --------------------------------------------------------

--
-- بنية الجدول `bot_message_templates`
--

CREATE TABLE `bot_message_templates` (
  `id` int(11) NOT NULL,
  `bot_id` int(11) NOT NULL,
  `template_key` varchar(64) NOT NULL,
  `template_text` text NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='ردود مخصصة لكل بوت - تتجاوز الردود العامة في message_templates';

-- --------------------------------------------------------

--
-- بنية الجدول `broadcast_jobs`
--

CREATE TABLE `broadcast_jobs` (
  `id` bigint(20) NOT NULL,
  `job_key` varchar(64) NOT NULL COMMENT 'Hash فريد لمنع التكرار',
  `initiator_user_id` bigint(20) NOT NULL COMMENT 'المالك الذي بدأ البث',
  `target_type` enum('label','all') NOT NULL,
  `target_label` varchar(64) DEFAULT NULL COMMENT 'اسم البوت إن كان label',
  `message_text` text NOT NULL,
  `media_type` enum('text','photo','video') DEFAULT 'text',
  `media_id` varchar(255) DEFAULT NULL,
  `status` enum('pending','running','completed','failed') DEFAULT 'pending',
  `total_recipients` int(11) DEFAULT 0,
  `sent_count` int(11) DEFAULT 0,
  `fail_count` int(11) DEFAULT 0,
  `scheduled_at` timestamp NULL DEFAULT NULL COMMENT 'للجدولة المستقبلية',
  `started_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول مهام البث الآمن';

-- --------------------------------------------------------

--
-- بنية الجدول `broadcast_log`
--

CREATE TABLE `broadcast_log` (
  `id` bigint(20) NOT NULL,
  `bot_token` varchar(128) NOT NULL COMMENT 'توكن البوت',
  `manager_id` bigint(20) NOT NULL COMMENT 'معرف المدير الذي قام بالبث',
  `message_text` text NOT NULL COMMENT 'نص الرسالة المرسلة',
  `recipients_count` int(11) DEFAULT 0 COMMENT 'عدد المستلمين',
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل عمليات البث للمدراء';

--
-- إرجاع أو استيراد بيانات الجدول `broadcast_log`
--

INSERT INTO `broadcast_log` (`id`, `bot_token`, `manager_id`, `message_text`, `recipients_count`, `created_at`) VALUES
(1, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'hi', 0, '2025-10-22 21:48:03'),
(2, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'هلو مناويج', 0, '2025-10-22 21:48:11'),
(3, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'ها كحبه', 0, '2025-10-22 21:50:50');

-- --------------------------------------------------------

--
-- بنية الجدول `control_sessions`
--

CREATE TABLE `control_sessions` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `action` varchar(64) NOT NULL,
  `bot_token` varchar(128) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Stand-in structure for view `current_usage`
-- (See below for the actual view)
--
CREATE TABLE `current_usage` (
`id` bigint(20)
,`user_id` bigint(20)
,`account_id` int(11)
,`day_used` int(11)
,`week_used` int(11)
,`month_used` int(11)
,`day_reset_at` timestamp
,`week_reset_at` timestamp
,`month_reset_at` timestamp
,`updated_at` timestamp
,`account_name` varchar(64)
,`current_day_used` int(11)
,`current_week_used` int(11)
,`current_month_used` int(11)
);

-- --------------------------------------------------------

--
-- بنية الجدول `group_accounts`
--

CREATE TABLE `group_accounts` (
  `group_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='ربط الحسابات بالمجموعات';

--
-- إرجاع أو استيراد بيانات الجدول `group_accounts`
--

INSERT INTO `group_accounts` (`group_id`, `account_id`, `created_at`) VALUES
(1, 106, '2025-10-23 20:25:43'),
(6, 42, '2025-10-24 16:41:26'),
(6, 102, '2025-10-23 00:14:05'),
(6, 104, '2025-10-24 16:40:55'),
(6, 105, '2025-10-24 16:42:18'),
(6, 107, '2025-10-24 16:41:47');

-- --------------------------------------------------------

--
-- بنية الجدول `limits_bot`
--

CREATE TABLE `limits_bot` (
  `bot_label` varchar(64) NOT NULL,
  `mode` enum('daily','weekly','monthly') NOT NULL,
  `per_day` int(11) NOT NULL,
  `weekly_cap` int(11) DEFAULT NULL,
  `monthly_cap` int(11) DEFAULT NULL,
  `ban_days` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='حدود خاصة لكل بوت (تتجاوز الحدود العامة)';

--
-- إرجاع أو استيراد بيانات الجدول `limits_bot`
--

INSERT INTO `limits_bot` (`bot_label`, `mode`, `per_day`, `weekly_cap`, `monthly_cap`, `ban_days`, `updated_at`) VALUES
('bot1', 'daily', 2, NULL, NULL, NULL, '2025-10-25 13:23:18');

-- --------------------------------------------------------

--
-- بنية الجدول `limits_global`
--

CREATE TABLE `limits_global` (
  `id` int(11) NOT NULL,
  `mode` enum('daily','weekly','monthly') NOT NULL DEFAULT 'daily' COMMENT 'الوضع: يومي/أسبوعي/شهري',
  `per_day` int(11) NOT NULL DEFAULT 2 COMMENT 'الحد اليومي (عدد الأكواد المسموح بها في اليوم)',
  `weekly_cap` int(11) DEFAULT NULL COMMENT 'السقف الأسبوعي (للوضع weekly فقط)',
  `monthly_cap` int(11) DEFAULT NULL COMMENT 'السقف الشهري (للوضع monthly فقط)',
  `ban_days` int(11) DEFAULT NULL COMMENT 'عدد أيام الحظر بعد التجاوز (NULL = لا حظر)',
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='الحدود العامة الافتراضية لجميع البوتات';

--
-- إرجاع أو استيراد بيانات الجدول `limits_global`
--

INSERT INTO `limits_global` (`id`, `mode`, `per_day`, `weekly_cap`, `monthly_cap`, `ban_days`, `updated_at`) VALUES
(1, 'weekly', 1, 2, NULL, 1000, '2025-10-24 17:09:59');

-- --------------------------------------------------------

--
-- بنية الجدول `limits_override`
--

CREATE TABLE `limits_override` (
  `account_id` int(11) NOT NULL,
  `mode` enum('daily','weekly','monthly') NOT NULL,
  `per_day` int(11) NOT NULL,
  `cap` int(11) DEFAULT NULL COMMENT 'السقف (أسبوعي أو شهري حسب الوضع)',
  `ban_days` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تجاوز الحدود لحساب محدد (أعلى أولوية)';

-- --------------------------------------------------------

--
-- بنية الجدول `limit_bans`
--

CREATE TABLE `limit_bans` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL COMMENT 'معرف المستخدم المحظور',
  `account_id` int(11) NOT NULL COMMENT 'معرف الحساب',
  `bot_label` varchar(50) NOT NULL COMMENT 'تسمية البوت',
  `banned_until` timestamp NOT NULL COMMENT 'الحظر ساري حتى هذا الوقت',
  `reason` varchar(255) DEFAULT NULL COMMENT 'سبب الحظر (weekly_exceeded, monthly_exceeded, manual)',
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل الحظر المؤقت';

-- --------------------------------------------------------

--
-- بنية الجدول `limit_counters`
--

CREATE TABLE `limit_counters` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL COMMENT 'معرف المستخدم في Telegram',
  `account_id` int(11) NOT NULL COMMENT 'معرف الحساب من steam_accounts',
  `bot_label` varchar(50) NOT NULL COMMENT 'تسمية البوت',
  `day_used` int(11) DEFAULT 0 COMMENT 'عدد الأكواد المستخدمة اليوم',
  `week_used` int(11) DEFAULT 0 COMMENT 'عدد الأكواد المستخدمة هذا الأسبوع',
  `month_used` int(11) DEFAULT 0 COMMENT 'عدد الأكواد المستخدمة هذا الشهر',
  `day_reset_at` timestamp NULL DEFAULT NULL COMMENT 'موعد إعادة تعيين العداد اليومي',
  `week_reset_at` timestamp NULL DEFAULT NULL COMMENT 'موعد إعادة تعيين العداد الأسبوعي',
  `month_reset_at` timestamp NULL DEFAULT NULL COMMENT 'موعد إعادة تعيين العداد الشهري',
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='عدادات الاستخدام لكل مستخدم × حساب';

--
-- إرجاع أو استيراد بيانات الجدول `limit_counters`
--

INSERT INTO `limit_counters` (`id`, `user_id`, `account_id`, `bot_label`, `day_used`, `week_used`, `month_used`, `day_reset_at`, `week_reset_at`, `month_reset_at`, `updated_at`) VALUES
(1, 5458195623, 102, 'bot1', 0, 0, 0, '2025-10-26 13:20:53', '2025-11-03 05:00:00', '2025-11-01 04:00:00', '2025-10-25 13:44:38'),
(2, 5458195623, 104, 'bot1', 0, 0, 0, '2025-10-26 13:20:53', '2025-11-03 05:00:00', '2025-11-01 04:00:00', '2025-10-25 13:44:38'),
(5, 5458195623, 105, 'bot1', 0, 0, 0, '2025-10-26 13:20:53', '2025-11-03 05:00:00', '2025-11-01 04:00:00', '2025-10-25 13:44:38'),
(6, 5458195623, 107, 'bot1', 0, 0, 0, '2025-10-26 13:20:53', '2025-11-03 05:00:00', '2025-11-01 04:00:00', '2025-10-25 13:44:38'),
(7, 5458195623, 42, 'bot1', 0, 0, 0, '2025-10-26 13:20:53', '2025-11-03 05:00:00', '2025-11-01 04:00:00', '2025-10-25 13:44:38'),
(8, 5458195623, 106, 'bot1', 7, 0, 0, '2025-10-26 13:20:53', '2025-11-03 05:00:00', '2025-11-01 04:00:00', '2025-10-25 13:44:38'),
(9, 6914878734, 105, 'bot1', 0, 0, 0, '2025-10-26 13:20:53', '2025-11-03 05:00:00', '2025-11-01 04:00:00', '2025-10-25 13:44:38');

-- --------------------------------------------------------

--
-- بنية الجدول `limit_messages`
--

CREATE TABLE `limit_messages` (
  `event` varchar(32) NOT NULL,
  `text` text NOT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='رسائل الأحداث القابلة للتخصيص';

--
-- إرجاع أو استيراد بيانات الجدول `limit_messages`
--

INSERT INTO `limit_messages` (`event`, `text`, `updated_at`) VALUES
('on_banned', '🚫 تم حظرك من الحساب {account} لمدة {ban_days} أيام.\n\n📅 الحظر ينتهي في: {banned_until}\n\nالسبب: تجاوزت الحد المسموح.', '2025-10-24 12:54:02'),
('on_daily_near', '⚠️ تنبيه: اقتربت من حدك اليومي!\n\n📊 الاستخدام: {day_used}/{per_day}\n💎 المتبقي: {remaining} طلبات\n🔄 إعادة التعيين: {reset_time}', '2025-10-24 12:54:02'),
('on_limit_hit', '⏳ لقد استهلكت حدك اليومي ({day_used}/{per_day}) للحساب {account}.\n\n🔄 إعادة التعيين: {reset_time}\n\n💡 تواصل مع المالك لزيادة حدودك.', '2025-10-24 12:54:02'),
('on_monthly_near', '⚠️ تنبيه: اقتربت من الحد الشهري!\n\n📊 الاستخدام: {month_used}/{monthly_cap}\n💎 المتبقي: {remaining} طلبات\n🔄 إعادة التعيين: بداية الشهر القادم', '2025-10-24 12:54:02'),
('on_share_warning', '⚠️ تحذير: هذا هو الطلب الرابع هذا الأسبوع!\n\n🔒 لا تشارك الحساب {account} مع آخرين.\n\n📊 الاستخدام الأسبوعي: {week_used}/{weekly_cap}\n⛔️ الحد الأقصى: {weekly_cap} طلبات/أسبوع\n🚫 التجاوز يؤدي للحظر لمدة {ban_days} أيام.', '2025-10-24 12:54:02'),
('on_unbanned', '✅ <b>تم إلغاء الحظر</b>\n\nيمكنك الآن استخدام حساب <code>{account}</code> مرة أخرى.\n\n⚠️ يُرجى الالتزام بالحدود لتجنب الحظر مجدداً.', '2025-10-23 22:44:50'),
('on_weekly_near', '⚠️ تنبيه: اقتربت من الحد الأسبوعي!\n\n📊 الاستخدام: {week_used}/{weekly_cap}\n💎 المتبقي: {remaining} طلبات\n🔄 إعادة التعيين: {reset_time}', '2025-10-24 12:54:02');

-- --------------------------------------------------------

--
-- بنية الجدول `message_templates`
--

CREATE TABLE `message_templates` (
  `key` varchar(64) NOT NULL,
  `text` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `message_templates`
--

INSERT INTO `message_templates` (`key`, `text`) VALUES
('code_reply', '🔐 الحساب: {account}\nالكود: <code>{code}</code>\n⏳ صالح لمدة ~30 ثانية.'),
('help_part1', '🧠 <b>لوحة أوامر الإدارة الشاملة</b>\r\n\r\nجميع الأوامر للمالك فقط.\r\n\r\n🛠 <b>قسم إدارة البوتات</b>\r\n\r\n<b>/addbot</b> <code>label token [channel] [max]</code>\r\n➡️ إضافة بوت جديد للنظام\r\n💡 <code>/addbot mybot 7123456:ABC @channel 100</code>\r\n📝 <i>label: اسم البوت، token: توكن من BotFather، channel: قناة اشتراك إلزامي، max: أقصى عدد مستخدمين</i>\r\n⚠️ <i>لتحديد عدد الطلبات: استخدم نظام الحدود الذكي (/help limits)</i>\r\n\r\n<b>/list</b>\r\n➡️ عرض جميع البوتات المسجلة مع تفاصيلها\r\n📊 يعرض: الاسم، عدد المستخدمين، الحالة، القناة\r\n\r\n<b>/bot_rename</b> <code>old_label new_label</code> 🆕\r\n➡️ تعديل اسم بوت (مع تحديث تلقائي للحدود والعدادات)\r\n💡 <code>/bot_rename test1 test_new</code>\r\n\r\n<b>/bot_details</b> <code>label</code> 🆕\r\n➡️ معلومات تفصيلية: المجموعات + الحسابات + الحدود\r\n💡 <code>/bot_details test1</code>\r\n\r\n<b>/pause</b> <code>label</code>\r\n➡️ إيقاف بوت مؤقتاً (لا يستجيب للمستخدمين)\r\n💡 <code>/pause mybot</code>\r\n\r\n<b>/resume</b> <code>label</code>\r\n➡️ تشغيل بوت متوقف\r\n💡 <code>/resume mybot</code>\r\n\r\n<b>/setmax</b> <code>label n</code>\r\n➡️ تحديد الحد الأقصى لعدد المستخدمين\r\n💡 <code>/setmax mybot 500</code>\r\n\r\n<b>/incmax</b> <code>label delta</code>\r\n➡️ زيادة الحد الأقصى بمقدار معين\r\n💡 <code>/incmax mybot 100</code> = زيادة 100 مستخدم\r\n\r\n<b>/setchannel</b> <code>label channel_id</code>\r\n➡️ تعديل قناة الاشتراك الإلزامية\r\n💡 <code>/setchannel mybot @mychannel</code>\r\n💡 <code>/setchannel mybot -1001234567890</code>\r\n\r\n<b>/settoken</b> <code>label new_token</code>\r\n➡️ تحديث توكن البوت\r\n💡 <code>/settoken mybot 7123456:NEW_TOKEN</code>\r\n\r\n<b>/setwelcome</b> <code>label text</code>\r\n➡️ تعديل رسالة الترحيب\r\n💡 <code>/setwelcome mybot مرحباً بك في البوت!</code>\r\n\r\n<b>/refreshbot</b> <code>label</code>\r\n➡️ إعادة تهيئة Webhook (مفيد بعد تغيير النطاق)\r\n💡 <code>/refreshbot mybot</code>\r\n\r\n<b>/deletebot</b> <code>label confirm</code>\r\n➡️ حذف البوت نهائياً من النظام\r\n⚠️ يتطلب كلمة confirm للتأكيد\r\n💡 <code>/deletebot mybot confirm</code>'),
('help_part10', '💡 <b>أمثلة عملية - حدود البوتات</b> ✨\r\n\r\n<b>مثال 1: بوت VIP بحدود أعلى</b>\r\n<code>/set_weekly vipbot 5 20 3</code>\r\n✅ 5 كود/يوم، 20/أسبوع، حظر 3 أيام فقط\r\n\r\n<b>مثال 2: بوت تجريبي بحد منخفض</b>\r\n<code>/set_daily testbot 1</code>\r\n✅ كود واحد يومياً، رفض فوري بعدها\r\n\r\n<b>مثال 3: بوت متميز بحد شهري</b>\r\n<code>/set_monthly premiumbot 10 100 7</code>\r\n✅ 10 كود/يوم، 100/شهر، حظر 7 أيام\r\n\r\n<b>مثال 4: عرض جميع البوتات وحدودها</b>\r\n<code>/show_limit bot</code>\r\n✅ قائمة كاملة بالبوتات وحدودها الخاصة والعامة\r\n\r\n<b>مثال 5: عرض بوت محدد</b>\r\n<code>/show_limit vipbot</code>\r\n<code>/show_limit bot/vipbot</code>\r\n✅ عرض تفصيلي لحدود البوت\r\n\r\n<b>مثال 6: حذف حدود خاصة</b>\r\n<code>/bot_limit_clear testbot</code>\r\n✅ يعود البوت لاستخدام الحدود العامة\r\n\r\n<b>مثال 7: حساب VIP بحدود خاصة</b>\r\n<code>/override_account 5 weekly 10 50 1</code>\r\n✅ 10 كود/يوم، 50/أسبوع، حظر يوم واحد فقط\r\n\r\n━━━━━━━━━━━━━━━━━\r\n💡 <b>نصائح:</b>\r\n• استخدم <code>/show_limit bot</code> لمراجعة جميع الحدود\r\n• البوتات بدون حدود خاصة تستخدم الحدود العامة تلقائياً\r\n• يمكنك تغيير حدود أي بوت في أي وقت\r\n• الأولوية: override > bot > global'),
('help_part2', '👥 <b>قسم إدارة المستخدمين</b>\n\n<b>/users</b> <code>label</code>\n➡️ عرض مستخدمي بوت معين (آخر 200)\n💡 <code>/users mybot</code>\n\n<b>/allusers</b>\n➡️ عرض جميع المستخدمين في النظام (DISTINCT)\n📊 يعرض: user_id، عدد البوتات المشترك بها\n\n<b>/ban</b> <code>user_id [label]</code>\n➡️ حظر مستخدم من بوت أو من جميع البوتات\n💡 <code>/ban 123456789</code> = حظر من كل البوتات\n💡 <code>/ban 123456789 mybot</code> = حظر من mybot فقط\n\n<b>/unban</b> <code>user_id [label]</code>\n➡️ إلغاء حظر مستخدم\n💡 <code>/unban 123456789</code> = فك من كل البوتات\n💡 <code>/unban 123456789 mybot</code> = فك من mybot فقط\n\n<b>/checkuser</b> <code>user_id</code>\n➡️ عرض نشاط المستخدم وعدد الأكواد المسحوبة\n💡 <code>/checkuser 123456789</code>\n📊 يعرض: البوتات المستخدمة، عدد الطلبات، آخر نشاط\n\n<b>/reset_limits</b> <code>user_id</code>\n➡️ إعادة ضبط المحاولات اليومية للمستخدم\n💡 <code>/reset_limits 123456789</code>\n🔄 يحذف طلبات آخر 24 ساعة'),
('help_part3', '🎮 <b>قسم الحسابات</b>\r\n\r\n<b>/accounts</b>\r\n➡️ عرض جميع حسابات Steam Guard\r\n📊 يعرض: الاسم، الحالة، محاولات يومية مخصصة\r\n\r\n<b>/addaccount</b> <code>name secret</code>\r\n➡️ إضافة حساب Steam Guard جديد\r\n💡 <code>/addaccount main_acc dG90YWxseV9yYW5kb20=</code>\r\n📝 <i>secret يجب أن يكون base64</i>\r\n\r\n<b>/addaccounts</b>\r\n➡️ إضافة عدة حسابات دفعة واحدة\r\n📝 أرسل الأمر، ثم أرسل في رسالة منفصلة:\r\n<code>account1:secret1\r\naccount2:secret2\r\naccount3:secret3</code>\r\n💡 مثال:\r\n<code>main:ABC123==\r\nvip:XYZ789==\r\nbackup:DEF456==</code>\r\n\r\n<b>/editaccount</b> <code>name secret [active]</code>\r\n➡️ تعديل بيانات حساب\r\n💡 <code>/editaccount main NEW_SECRET 1</code>\r\n💡 <code>/editaccount main same 0</code> = تعطيل بدون تغيير السر\r\n\r\n<b>/disableaccount</b> <code>name</code>\r\n➡️ تعطيل حساب (لن يُستخدم في توليد الأكواد)\r\n💡 <code>/disableaccount backup</code>\r\n\r\n<b>/enableaccount</b> <code>name</code>\r\n➡️ تفعيل حساب معطل\r\n💡 <code>/enableaccount backup</code>\r\n\r\n<b>/account_details</b> <code>name_or_id</code> 🆕\r\n➡️ معلومات شاملة: المجموعة + البوتات + الحدود الخاصة\r\n💡 <code>/account_details steamuser1</code>\r\n💡 <code>/account_details 42</code>\r\n\r\n<b>/deleteaccount</b> <code>name</code>\r\n➡️ حذف حساب نهائياً من النظام\r\n⚠️ لا يمكن التراجع!\r\n💡 <code>/deleteaccount old_account</code>\r\n\r\n<b>/accountinfo</b> <code>name</code>\r\n➡️ عرض معلومات تفصيلية عن حساب\r\n💡 <code>/accountinfo main</code>\r\n📊 يعرض: الحالة، إجمالي الطلبات، آخر استخدام'),
('help_part4', '📂 <b>قسم المجموعات</b> (النظام الجديد) ✨\r\n\r\n💡 <i>نظام متطور لتجميع الحسابات وربطها بالبوتات</i>\r\n\r\n<b>📋 إدارة المجموعات:</b>\r\n<b>/group_add</b> <code>name</code> - إنشاء مجموعة جديدة\r\n💡 <code>/group_add vip</code>\r\n\r\n<b>/group_rename</b> <code>old new</code> - إعادة تسمية 🆕\r\n💡 <code>/group_rename vip premium</code>\r\n\r\n<b>/group_delete</b> <code>name confirm</code> - حذف نهائي 🆕\r\n💡 <code>/group_delete old confirm</code>\r\n\r\n<b>/group_lock</b> <code>name</code> - قفل (منع rename/delete) 🆕\r\n<b>/group_unlock</b> <code>name</code> - فتح القفل 🆕\r\n\r\n<b>/groups_list</b> - عرض جميع المجموعات\r\n💡 يعرض المجموعات مع عداد البوتات والحسابات\r\n\r\n<b>/group_details</b> <code>name</code> 🆕\r\n➡️ معلومات تفصيلية: البوتات + الحسابات (بالأسماء والأرقام)\r\n💡 <code>/group_details default</code>\r\n\r\n<b>/group_info</b> <code>group</code> - تفاصيل مجموعة\r\n💡 <code>/group_info default</code>\r\n\r\n<b>/group_toggle</b> <code>group</code> - تفعيل/تعطيل\r\n💡 <code>/group_toggle vip</code>\r\n\r\n<b>/group_usage</b> <code>group</code> - إحصائيات الاستخدام 🆕\r\n💡 <code>/group_usage vip</code>\r\n\r\n<b>🤖 ربط البوتات:</b>\r\n<b>/group_bind</b> <code>bot group</code> - ربط بوت بمجموعة\r\n💡 <code>/group_bind mybot vip</code>\r\n\r\n<b>/group_unbind</b> <code>bot group</code> - فك ربط بوت\r\n💡 <code>/group_unbind mybot vip</code>\r\n\r\n<b>/bot_groups</b> <code>bot</code> - عرض مجموعات وحسابات بوت 🆕\r\n💡 <code>/bot_groups mybot</code>\r\n\r\n<b>👤 إدارة الحسابات (دفعات):</b>\r\n<b>/group_account_add</b> <code>group acc1 acc2 ...</code> 🆕\r\n➡️ إضافة حسابات لمجموعة (دفعة واحدة)\r\n💡 <code>/group_account_add vip acc1 acc2 acc3</code>\r\n\r\n<b>/group_account_del</b> <code>group acc1 acc2 ...</code> 🆕\r\n➡️ إزالة حسابات من مجموعة (دفعة واحدة)\r\n💡 <code>/group_account_del vip acc1 acc2</code>\r\n\r\n⚠️ <i>البوت يرى فقط الحسابات الموجودة في مجموعاته</i>'),
('help_part5', '🎫 <b>قسم القسائم</b> 🆕\r\n\r\n💡 <i>لزيادة حدود المستخدمين أو إضافة أيام</i>\r\n\r\n<b>/generate_voucher</b> <code>type amount [bot] [uses]</code>\r\n➡️ إنشاء قسيمة جديدة\r\n\r\n<b>الأنواع:</b> users | days\r\n\r\n💡 <code>/generate_voucher users 100 mybot 1</code>\r\n💡 <code>/generate_voucher users 50 all 5</code>\r\n\r\n<b>/redeem</b> <code>code [bot]</code> - تفعيل قسيمة\r\n💡 <code>/redeem ABC123 mybot</code>\r\n\r\n<b>/vouchers</b> - عرض جميع القسائم\r\n<b>/voucher_search</b> <code>code</code> - بحث عن قسيمة\r\n\r\n<b>/voucher_who_used</b> <code>code</code> - تقرير الاستخدام 🆕\r\n💡 <code>/voucher_who_used ABC123</code>\r\n➡️ يعرض البوتات التي استخدمت القسيمة مع التواريخ\r\n\r\n<b>/voucher_delete</b> <code>code</code> - حذف قسيمة نهائياً 🆕\r\n💡 <code>/voucher_delete ABC123</code>\r\n⚠️ لا يمكن التراجع!\r\n\r\n<b>/voucher_stats</b> - إحصائيات القسائم 🆕\r\n📊 يعرض: إجمالي القسائم، المستخدمة، المتبقية، معدل الاستخدام'),
('help_part6', '📢 <b>قسم البث</b>\n\n<b>/broadcast</b> <code>label text</code>\n➡️ إرسال رسالة لمستخدمي بوت معين\n💡 <code>/broadcast mybot مرحباً بكم في التحديث الجديد!</code>\n📝 يُرسل لجميع المستخدمين غير المحظورين\n\n<b>/broadcast_all</b> <code>text</code>\n➡️ إرسال رسالة لجميع مستخدمي كل البوتات\n💡 <code>/broadcast_all إشعار عام للجميع</code>\n⚠️ قد يستغرق وقتاً طويلاً مع عدد كبير من المستخدمين\n\n━━━━━━━━━━━━━━━━━\n\n💬 <b>قسم الردود</b>\n\n<b>/responses</b>\n➡️ عرض جميع قوالب الردود المعرفة\n📝 يعرض المفتاح والنص (أول 200 حرف)\n\n<b>/editresponse</b> <code>key text</code>\n➡️ تعديل رد معين\n💡 <code>/editresponse start_1 مرحباً بك!</code>\n📝 القوالب المتاحة: start_1, code_reply, invalid_account, rate_limited, paused'),
('help_part7', '💬 <b>قسم الردود</b> (محسّن) ✨\r\n\r\n💡 <i>نظام ردود متقدم: عامة لكل البوتات أو مخصصة لبوت واحد</i>\r\n\r\n<b>📋 عرض الردود:</b>\r\n<b>/responses</b> - عرض الردود العامة\r\n<b>/bot_responses</b> <code>bot</code> - ردود بوت مخصصة 🆕\r\n💡 <code>/bot_responses mybot</code>\r\n\r\n<b>✏️ تعديل الردود العامة:</b>\r\n<b>/edit_global_response</b> <code>key text</code> 🆕\r\n➡️ يُحدّث رد عام لجميع البوتات\r\n💡 <code>/edit_global_response start_1 مرحباً!</code>\r\n\r\n<b>/editresponse</b> <code>key text</code>\r\n➡️ نفس الأمر أعلاه (قديم)\r\n\r\n<b>🤖 تعديل ردود بوت معين:</b>\r\n<b>/edit_bot_response</b> <code>bot key text</code> 🆕\r\n➡️ رد مخصص لبوت واحد فقط\r\n💡 <code>/edit_bot_response mybot start_1 مرحباً في بوتي!</code>\r\n\r\n<b>🔧 أوامر إضافية:</b>\r\n<b>/copy_global_to_bot</b> <code>key bot</code> 🆕\r\n➡️ نسخ رد عام ليصبح مخصص لبوت\r\n\r\n<b>/delete_bot_response</b> <code>bot key</code> 🆕\r\n➡️ حذف رد مخصص (يعود للرد العام)\r\n\r\n<b>📚 القوالب المتاحة:</b>\r\n• <code>start_1</code> - رسالة البداية\r\n• <code>code_reply</code> - رد الكود\r\n• <code>invalid_account</code> - حساب خاطئ\r\n• <code>rate_limited</code> - تجاوز الحد\r\n• <code>paused</code> - بوت متوقف'),
('help_part8', '👨‍💼 <b>قسم المدراء الفرعيين</b> 🆕\n\nيمكنك إضافة مدراء فرعيين لمساعدتك في إدارة البوتات مع صلاحيات محددة.\n\n📋 <b>أوامر إدارة المدراء:</b>\n\n<b>/managers_all</b>\n➡️ عرض جميع المدراء الفرعيين في النظام\n📊 يعرض: ID، اسم المستخدم، البوت، الصلاحيات، تاريخ الإضافة\n\n<b>/managers</b> <code>label</code>\n➡️ عرض مدراء بوت معين\n💡 <code>/managers mybot</code>\n\n<b>/addmanager</b> <code>label user_id [permissions]</code>\n➡️ إضافة مدير لبوت محدد\n💡 <code>/addmanager mybot 123456789 1:2:3</code>\n💡 <code>/addmanager mybot 123456789 all</code>\n📝 الصلاحيات الافتراضية: 1:2:3:4:5 (إذا لم تُحدد)\n\n<b>/addmanager_all</b> <code>user_id [permissions]</code>\n➡️ إضافة مدير عام لجميع البوتات\n💡 <code>/addmanager_all 123456789 all</code>\n💡 <code>/addmanager_all 123456789 1:2</code>\n⚠️ المدير العام يملك صلاحيات في كل البوتات\n\n<b>/removemanager</b> <code>label user_id</code>\n➡️ إزالة مدير من بوت محدد\n💡 <code>/removemanager mybot 123456789</code>\n\n<b>/removemanager_all</b> <code>user_id</code>\n➡️ إزالة مدير من جميع البوتات\n💡 <code>/removemanager_all 123456789</code>\n\n<b>/managerinfo</b> <code>user_id</code>\n➡️ عرض معلومات وصلاحيات مدير معين\n💡 <code>/managerinfo 123456789</code>\n📊 يعرض: البوتات المُدارة، الصلاحيات لكل بوت، تاريخ الإضافة\n\n🔐 <b>الصلاحيات المتاحة:</b>\n1️⃣ = بث (Broadcast) - إرسال رسائل جماعية\n2️⃣ = حظر (Ban/Unban) - حظر وإلغاء حظر المستخدمين\n3️⃣ = تعبئة قسائم (Vouchers) - تفعيل القسائم\n4️⃣ = عرض المستخدمين - الوصول لقائمة المستخدمين\n5️⃣ = البحث عن مستخدم - البحث والتحقق من المستخدمين\n6️⃣ = تعديل حدود المستخدم - تغيير المحاولات اليومية\n✨ = <code>all</code> - جميع الصلاحيات\n\n💡 <b>أمثلة على الصلاحيات:</b>\n• <code>1:2:3</code> = بث + حظر + قسائم\n• <code>2:4:5</code> = حظر + عرض المستخدمين + البحث\n• <code>all</code> = كل الصلاحيات\n\n⚠️ <b>ملاحظات مهمة:</b>\n• الصلاحيات تُفصل بـ <code>:</code> بدون مسافات\n• المدير العام (bot_token=NULL) له صلاحيات في كل البوتات\n• يمكن للمدير أن يكون في عدة بوتات بصلاحيات مختلفة\n• إضافة مدير موجود تُحدّث صلاحياته بدلاً من التكرار'),
('help_part9', '🎯 <b>نظام الحدود الذكي</b> 🆕✨\r\n\r\n💡 <i>نظام متقدم مع 3 أوضاع: يومي/أسبوعي/شهري</i>\r\n\r\n<b>🌍 الحدود العامة:</b>\r\n<b>/limit_mode_all</b> <code>mode</code>\r\n➡️ تغيير الوضع العام (daily/weekly/monthly)\r\n💡 <code>/limit_mode_all weekly</code>\r\n\r\n<b>/set_daily_all</b> <code>per_day</code>\r\n➡️ تعيين حد يومي عام\r\n💡 <code>/set_daily_all 3</code>\r\n\r\n<b>/set_weekly_all</b> <code>per_day weekly_cap ban_days</code>\r\n➡️ حد أسبوعي: يومي + سقف أسبوعي + مدة حظر\r\n💡 <code>/set_weekly_all 2 6 7</code>\r\n\r\n<b>/set_monthly_all</b> <code>per_day monthly_cap ban_days</code>\r\n➡️ حد شهري: يومي + سقف شهري + مدة حظر\r\n💡 <code>/set_monthly_all 2 20 30</code>\r\n\r\n<b>🤖 حدود البوتات (متقدمة):</b> ✨\r\n<b>/limit_mode</b> <code>bot mode</code>\r\n➡️ تعيين وضع خاص لبوت محدد\r\n💡 <code>/limit_mode mybot weekly</code>\r\n\r\n<b>/set_daily</b> <code>bot per_day</code> 🆕\r\n➡️ حد يومي دقيق لبوت محدد\r\n💡 <code>/set_daily testbot 1</code>\r\n\r\n<b>/set_weekly</b> <code>bot per_day cap ban</code> 🆕\r\n➡️ حد أسبوعي دقيق لبوت محدد\r\n💡 <code>/set_weekly vipbot 5 20 3</code>\r\n\r\n<b>/set_monthly</b> <code>bot per_day cap ban</code> 🆕\r\n➡️ حد شهري دقيق لبوت محدد\r\n💡 <code>/set_monthly premiumbot 10 100 7</code>\r\n\r\n<b>/bot_limit_clear</b> <code>bot</code> 🆕\r\n➡️ حذف الحدود الخاصة (العودة للعامة)\r\n💡 <code>/bot_limit_clear testbot</code>\r\n\r\n<b>👤 التجاوز (حدود خاصة):</b>\r\n<b>/override_account</b> <code>id mode per_day [cap] [ban]</code>\r\n➡️ حدود مخصصة لحساب محدد (أعلى أولوية)\r\n💡 <code>/override_account 5 weekly 3 10 7</code>\r\n\r\n<b>/override_clear</b> <code>id</code> - حذف التجاوز\r\n\r\n<b>📊 الاستعلام (محدّث):</b> ✨\r\n<b>/show_limit</b> <code>target</code>\r\n➡️ عرض الحدود (global/bot/bot/label/account_id)\r\n💡 <code>/show_limit global</code>\r\n💡 <code>/show_limit bot</code> - جميع البوتات 🆕\r\n💡 <code>/show_limit bot/vipbot</code> - بوت محدد 🆕\r\n💡 <code>/show_limit vipbot</code> - بوت محدد\r\n💡 <code>/show_limit 5</code> - حساب محدد\r\n\r\n<b>/reset_counters</b> <code>target</code>\r\n➡️ إعادة تعيين العدادات (user_id/all)\r\n💡 <code>/reset_counters 123456789</code>\r\n\r\n<b>⛔ الحظر:</b>\r\n<b>/ban_from_account</b> <code>user_id account_id days</code>\r\n➡️ حظر مستخدم من حساب لمدة محددة\r\n💡 <code>/ban_from_account 123456789 5 7</code>\r\n\r\n<b>/unban_from_account</b> <code>user_id account_id</code>\r\n➡️ إلغاء حظر مستخدم من حساب\r\n\r\n<b>💬 الرسائل:</b>\r\n<b>/msg_set</b> <code>event text</code> - تخصيص رسالة\r\n<b>/msg_show</b> - عرض جميع الرسائل\r\n\r\n<b>📝 الأوضاع:</b>\r\n• <b>daily:</b> 2 كود/يوم (رفض فوري)\r\n• <b>weekly:</b> 2 كود/يوم + 6/أسبوع (حظر 7 أيام)\r\n• <b>monthly:</b> 2 كود/يوم + 20/شهر (حظر 30 يوم)\r\n\r\n<b>🎯 الأولوية:</b>\r\noverride → bot → global'),
('help_stats', '📊 <b>قسم الإحصائيات</b>\r\n\r\n<b>/stats</b> - إحصائيات عامة\r\n<b>/stats</b> <code>label</code> - إحصائيات بوت معين\r\n\r\n<b>البيانات:</b>\r\n• عدد المستخدمين\r\n• عدد البوتات\r\n• عدد الحسابات النشطة\r\n• عدد المجموعات\r\n• عدد القسائم\r\n• إجمالي الأكواد المسحوبة'),
('help_system', '⚙️ <b>قسم الصيانة والنظام</b>\r\n\r\n<b>/system_status</b> - حالة النظام\r\n<b>/clear_cache</b> - مسح الذاكرة المؤقتة\r\n<b>/backup_db</b> - نسخ احتياطي للقاعدة\r\n<b>/system_logs</b> - عرض آخر 50 سجل\r\n\r\n💡 <i>أوامر متقدمة للمطورين فقط</i>'),
('invalid_account', '❌ اسم الحساب غير صحيح أو غير مفعل.'),
('max_users_reached', '🚫 تم الوصول إلى الحد الأقصى للمستخدمين المسموح لهم في هذا البوت.'),
('not_subscribed', '🔔 للحصول على أكواد التحقق يرجى الاشتراك في القناة أولاً.💙'),
('paused', '⏸ البوت متوقف مؤقتاً. يرجى المحاولة لاحقاً.'),
('rate_limited', '⏱️ لقد تجاوزت الحد اليومي للمحاولات لهذا الحساب. حاول غدًا.'),
('start_1', '👋 مرحباً!'),
('start_2', 'أرسل اسم الحساب للحصول على الكود.');

-- --------------------------------------------------------

--
-- بنية الجدول `steam_accounts`
--

CREATE TABLE `steam_accounts` (
  `id` int(11) NOT NULL,
  `account_name` varchar(64) NOT NULL,
  `shared_secret` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `daily_attempts_override` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `steam_accounts`
--

INSERT INTO `steam_accounts` (`id`, `account_name`, `shared_secret`, `active`, `daily_attempts_override`, `created_at`, `updated_at`) VALUES
(42, 'greatpackagebot1', 'UiqwIKc1r3i8EBFaElesiJqyWRY=', 1, NULL, '2025-08-27 12:51:18', '2025-08-27 12:51:18'),
(102, 'greatpackage54', 'Wwk7P/Ed+1vBGY9adWTV0il7IK0=', 1, NULL, '2025-10-22 23:02:28', '2025-10-22 23:02:28'),
(104, 'Greatpackage1', 'QvejS/EjScYcegOB0P8aSjZBubk=', 1, NULL, '2025-10-23 00:17:00', '2025-10-23 00:17:00'),
(105, 'pastoralshakyherring', '2fqpkmgLdw1i5W1QFw1eKnJsu0U=', 1, NULL, '2025-10-23 20:25:38', '2025-10-23 20:25:38'),
(106, 'wastefulstupidlapwing', '6HRupM75CQJGor2E1qAa+Y7RJP4=', 1, NULL, '2025-10-23 20:25:43', '2025-10-23 20:25:43'),
(107, 'lackinghulkingbear', 'p47+J37M10PAB78X2JgJQcfpXRA=', 1, NULL, '2025-10-24 16:23:57', '2025-10-24 16:23:57');

--
-- القوادح `steam_accounts`
--
DELIMITER $$
CREATE TRIGGER `trg_steam_accounts_after_insert` AFTER INSERT ON `steam_accounts` FOR EACH ROW BEGIN
  INSERT IGNORE INTO group_accounts(group_id, account_id)
  SELECT id, NEW.id FROM account_groups WHERE is_default=1;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- بنية الجدول `steam_requests`
--

CREATE TABLE `steam_requests` (
  `id` bigint(20) NOT NULL,
  `bot_token` varchar(128) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `account_name` varchar(64) NOT NULL,
  `request_time` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `steam_requests`
--

INSERT INTO `steam_requests` (`id`, `bot_token`, `user_id`, `account_name`, `request_time`) VALUES
(64, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'Greatpackage1', '2025-10-24 16:55:45'),
(61, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:55:23'),
(62, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:55:27'),
(66, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:55:57'),
(67, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:56:03'),
(68, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:56:24'),
(69, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:56:26'),
(70, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:56:27'),
(71, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'greatpackagebot1', '2025-10-24 16:56:29'),
(65, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'lackinghulkingbear', '2025-10-24 16:55:47'),
(63, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 5458195623, 'pastoralshakyherring', '2025-10-24 16:55:43'),
(77, '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', 6914878734, 'pastoralshakyherring', '2025-10-24 17:32:49'),
(72, '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', 5458195623, 'Greatpackage1', '2025-10-24 17:07:46'),
(73, '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', 5458195623, 'lackinghulkingbear', '2025-10-24 17:07:49'),
(75, '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', 5458195623, 'lackinghulkingbear', '2025-10-24 17:08:12'),
(76, '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', 5458195623, 'lackinghulkingbear', '2025-10-24 17:08:15'),
(74, '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', 5458195623, 'pastoralshakyherring', '2025-10-24 17:07:51'),
(3, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-23 00:17:14'),
(4, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-23 20:27:46'),
(5, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 12:54:24'),
(6, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 12:54:44'),
(29, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:21:48'),
(30, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:21:51'),
(31, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:21:53'),
(32, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:29:21'),
(33, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:29:27'),
(34, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:29:31'),
(35, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:29:33'),
(36, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:29:35'),
(38, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 13:36:50'),
(55, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 16:38:31'),
(59, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'Greatpackage1', '2025-10-24 16:46:20'),
(1, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-22 23:04:21'),
(2, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-23 00:15:17'),
(7, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:55:08'),
(8, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:55:11'),
(9, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:55:13'),
(10, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:55:14'),
(11, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:55:17'),
(12, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:55:20'),
(13, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:56:41'),
(14, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:56:44'),
(15, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 12:56:47'),
(16, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:07:33'),
(17, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:07:36'),
(18, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:07:40'),
(19, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:07:42'),
(20, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:08:02'),
(21, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:17:23'),
(22, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:17:25'),
(23, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:17:27'),
(24, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:17:29'),
(25, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:17:31'),
(26, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:17:32'),
(27, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:17:34'),
(28, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:21:34'),
(37, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:36:31'),
(39, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:37:17'),
(40, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:41:54'),
(41, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:41:56'),
(42, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:41:59'),
(43, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:45:10'),
(44, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:45:36'),
(45, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackage54', '2025-10-24 13:45:40'),
(54, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackagebot1', '2025-10-24 16:38:25'),
(60, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'greatpackagebot1', '2025-10-24 16:46:24'),
(53, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'lackinghulkingbear', '2025-10-24 16:38:22'),
(57, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'lackinghulkingbear', '2025-10-24 16:46:15'),
(52, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'pastoralshakyherring', '2025-10-24 16:38:19'),
(58, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'pastoralshakyherring', '2025-10-24 16:46:18'),
(56, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-24 16:38:53'),
(78, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 12:34:48'),
(79, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 13:21:13'),
(80, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 13:21:15'),
(81, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 13:21:17'),
(82, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 13:21:19'),
(83, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 13:21:21'),
(84, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 13:21:22'),
(85, '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 'wastefulstupidlapwing', '2025-10-25 13:21:24');

-- --------------------------------------------------------

--
-- بنية الجدول `sub_bots`
--

CREATE TABLE `sub_bots` (
  `id` int(11) NOT NULL,
  `label` varchar(64) NOT NULL,
  `bot_token` varchar(128) NOT NULL,
  `channel_id` varchar(64) DEFAULT NULL,
  `max_users` int(11) NOT NULL DEFAULT 20,
  `daily_attempts` int(11) NOT NULL DEFAULT 5 COMMENT 'معطّل - استخدم نظام الحدود الذكي (limits_global)',
  `welcome_message` text DEFAULT NULL,
  `is_paused` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `sub_bots`
--

INSERT INTO `sub_bots` (`id`, `label`, `bot_token`, `channel_id`, `max_users`, `daily_attempts`, `welcome_message`, `is_paused`, `created_at`, `updated_at`) VALUES
(27, 'bot1', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', '-1003169820528', 100232, 2, 'حلل نظام ال group في المشروع الحالي اريد تقرير مفصل مع تتبع كل كود برمجي من لحظه الادخال إلى لحظه الاخراج \nوتتبع الاوامر الخاصه بها امر امر وتحقق من وظائفها \nوهل النظام الحالي يطبق الفكره حيث كل بوت فرعي يرسل اكواد الحسابات الداخل المجموعة المرتبط بها', 0, '2025-10-22 20:36:17', '2025-10-25 16:05:49'),
(28, 'test2', '8236123812:AAE3b7Z1CumdvT4xlDsQDM3r7D49mIHKapc', '-1003169820528', 2, 5, 'https://i.imgur.com/Lx4VhQd.jpeg', 0, '2025-10-24 16:48:05', '2025-10-25 12:55:33'),
(29, 'test3', '8427167545:AAEZklQlLphbCKHkk0qt3pTxp1VdlzvnZ0M', '-1003169820528', 2, 5, 'https://imgur.com/gallery/5-werewolves-day-keeps-van-helsing-away-24-tOgijdV', 0, '2025-10-24 17:02:33', '2025-10-25 12:55:33');

--
-- القوادح `sub_bots`
--
DELIMITER $$
CREATE TRIGGER `trg_sub_bots_after_insert` AFTER INSERT ON `sub_bots` FOR EACH ROW BEGIN
  INSERT IGNORE INTO bot_groups(bot_id, group_id)
  SELECT NEW.id, id FROM account_groups WHERE is_default=1;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- بنية الجدول `system_logs`
--

CREATE TABLE `system_logs` (
  `id` bigint(20) NOT NULL,
  `log_level` enum('INFO','WARNING','ERROR','CRITICAL') DEFAULT 'INFO',
  `component` varchar(64) NOT NULL COMMENT 'control_bot, sub_bot, broadcast',
  `message` text NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'بيانات إضافية' CHECK (json_valid(`context`)),
  `user_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجلات النظام للتدقيق';

-- --------------------------------------------------------

--
-- بنية الجدول `vouchers`
--

CREATE TABLE `vouchers` (
  `id` bigint(20) NOT NULL,
  `code` varchar(32) NOT NULL,
  `voucher_type` enum('users','days','unlimited') DEFAULT 'users',
  `amount` int(11) NOT NULL COMMENT 'عدد المستخدمين أو الأيام',
  `target_label` varchar(64) DEFAULT NULL COMMENT 'اسم البوت المحدد أو NULL للكل',
  `max_uses` int(11) DEFAULT 1 COMMENT 'عدد مرات الاستخدام المسموح',
  `current_uses` int(11) DEFAULT 0 COMMENT 'عدد الاستخدامات الحالية',
  `expires_at` timestamp NULL DEFAULT NULL COMMENT 'تاريخ انتهاء الصلاحية',
  `created_by_user_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='قسائم لزيادة حدود المستخدمين أو الأيام';

--
-- إرجاع أو استيراد بيانات الجدول `vouchers`
--

INSERT INTO `vouchers` (`id`, `code`, `voucher_type`, `amount`, `target_label`, `max_uses`, `current_uses`, `expires_at`, `created_by_user_id`, `created_at`) VALUES
(1, 'V7CDC741AB9', 'users', 200, NULL, 5, 5, NULL, 5458195623, '2025-10-22 22:53:04'),
(2, 'VC8B023B368', 'users', 200, NULL, 1, 1, NULL, 5458195623, '2025-10-22 22:55:28'),
(3, 'V41F5ED6080', 'users', 200, NULL, 1, 1, NULL, 5458195623, '2025-10-22 22:58:18'),
(4, 'VDA3EEA5221', 'users', 200, NULL, 1, 0, NULL, 5458195623, '2025-10-22 22:59:04'),
(5, 'V0A744D4400', 'users', 100000, NULL, 1, 1, NULL, 5458195623, '2025-10-23 21:27:09'),
(6, 'V3D412A162D', 'users', 100000, NULL, 1, 1, NULL, 5458195623, '2025-10-24 17:36:20'),
(7, 'V0BD6CE01F0', 'users', 55, '3', 1, 1, NULL, 5458195623, '2025-10-24 17:37:08'),
(8, 'VEAD32AF223', 'users', 55, NULL, 3, 3, NULL, 5458195623, '2025-10-24 17:38:18');

-- --------------------------------------------------------

--
-- بنية الجدول `voucher_redemptions`
--

CREATE TABLE `voucher_redemptions` (
  `id` bigint(20) NOT NULL,
  `voucher_code` varchar(32) NOT NULL COMMENT 'رمز القسيمة',
  `bot_token` varchar(128) NOT NULL COMMENT 'توكن البوت',
  `redeemed_by` bigint(20) NOT NULL COMMENT 'المدير الذي استخدم القسيمة',
  `amount_added` int(11) DEFAULT 0 COMMENT 'القيمة المضافة',
  `redeemed_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='سجل استخدام القسائم من قبل المدراء';

--
-- إرجاع أو استيراد بيانات الجدول `voucher_redemptions`
--

INSERT INTO `voucher_redemptions` (`id`, `voucher_code`, `bot_token`, `redeemed_by`, `amount_added`, `redeemed_at`) VALUES
(1, 'V7CDC741AB9', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 200, '2025-10-22 22:53:28'),
(2, 'V7CDC741AB9', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 200, '2025-10-22 22:54:33'),
(3, 'V7CDC741AB9', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 200, '2025-10-22 22:54:43'),
(4, 'V7CDC741AB9', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 200, '2025-10-22 22:55:12'),
(5, 'V7CDC741AB9', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 200, '2025-10-22 22:55:13'),
(6, 'VC8B023B368', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 200, '2025-10-22 22:55:46'),
(7, 'V41F5ED6080', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 200, '2025-10-22 22:58:26'),
(8, 'V0A744D4400', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 100000, '2025-10-23 21:27:24'),
(9, 'V3D412A162D', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 100000, '2025-10-24 17:36:37'),
(10, 'V0BD6CE01F0', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 55, '2025-10-24 17:37:24'),
(11, 'VEAD32AF223', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 55, '2025-10-24 17:38:30'),
(12, 'VEAD32AF223', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 55, '2025-10-24 17:38:33'),
(13, 'VEAD32AF223', '8472644537:AAHfCDfrXYcUXgn89MQVhxY-sBHhumcefug', 5458195623, 55, '2025-10-24 17:38:35');

-- --------------------------------------------------------

--
-- بنية الجدول `voucher_usage`
--

CREATE TABLE `voucher_usage` (
  `id` bigint(20) NOT NULL,
  `voucher_code` varchar(64) NOT NULL,
  `bot_id` int(11) DEFAULT NULL,
  `used_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تتبع استخدام القسائم من قبل البوتات';

--
-- إرجاع أو استيراد بيانات الجدول `voucher_usage`
--

INSERT INTO `voucher_usage` (`id`, `voucher_code`, `bot_id`, `used_at`) VALUES
(1, 'V7CDC741AB9', 27, '2025-10-22 18:53:28'),
(2, 'V7CDC741AB9', 27, '2025-10-22 18:54:33'),
(3, 'V7CDC741AB9', 27, '2025-10-22 18:54:43'),
(4, 'V7CDC741AB9', 27, '2025-10-22 18:55:12'),
(5, 'V7CDC741AB9', 27, '2025-10-22 18:55:13'),
(6, 'VC8B023B368', 27, '2025-10-22 18:55:46'),
(7, 'V41F5ED6080', 27, '2025-10-22 18:58:26'),
(8, 'V0A744D4400', 27, '2025-10-23 17:27:24'),
(9, 'V3D412A162D', 27, '2025-10-24 13:36:37'),
(10, 'V0BD6CE01F0', 27, '2025-10-24 13:37:24'),
(11, 'VEAD32AF223', 27, '2025-10-24 13:38:30'),
(12, 'VEAD32AF223', 27, '2025-10-24 13:38:33'),
(13, 'VEAD32AF223', 27, '2025-10-24 13:38:35');

--
-- Indexes for dumped tables
--

--
-- فهارس للجدول `account_groups`
--
ALTER TABLE `account_groups`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `group_name` (`group_name`),
  ADD UNIQUE KEY `idx_unique_group_name_lower` (`group_name_lower`),
  ADD KEY `idx_default` (`is_default`),
  ADD KEY `idx_priority` (`priority`),
  ADD KEY `idx_active` (`active`);

--
-- فهارس للجدول `allowed_users`
--
ALTER TABLE `allowed_users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_user_bot` (`bot_token`,`user_id`),
  ADD KEY `idx_bot` (`bot_token`),
  ADD KEY `idx_user` (`user_id`);

--
-- فهارس للجدول `bot_groups`
--
ALTER TABLE `bot_groups`
  ADD PRIMARY KEY (`bot_id`,`group_id`),
  ADD KEY `group_id` (`group_id`);

--
-- فهارس للجدول `bot_managers`
--
ALTER TABLE `bot_managers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_manager_bot` (`user_id`,`bot_token`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_bot` (`bot_token`),
  ADD KEY `idx_active` (`is_active`);

--
-- فهارس للجدول `bot_message_templates`
--
ALTER TABLE `bot_message_templates`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_bot_template` (`bot_id`,`template_key`),
  ADD KEY `idx_bot_id` (`bot_id`),
  ADD KEY `idx_template_key` (`template_key`);

--
-- فهارس للجدول `broadcast_jobs`
--
ALTER TABLE `broadcast_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `job_key` (`job_key`),
  ADD KEY `idx_status` (`status`,`scheduled_at`),
  ADD KEY `idx_initiator` (`initiator_user_id`),
  ADD KEY `idx_job_key` (`job_key`);

--
-- فهارس للجدول `broadcast_log`
--
ALTER TABLE `broadcast_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_bot_token` (`bot_token`),
  ADD KEY `idx_manager` (`manager_id`),
  ADD KEY `idx_created` (`created_at`),
  ADD KEY `idx_bot_time` (`bot_token`,`created_at`);

--
-- فهارس للجدول `control_sessions`
--
ALTER TABLE `control_sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_user` (`user_id`);

--
-- فهارس للجدول `group_accounts`
--
ALTER TABLE `group_accounts`
  ADD PRIMARY KEY (`group_id`,`account_id`),
  ADD KEY `account_id` (`account_id`);

--
-- فهارس للجدول `limits_bot`
--
ALTER TABLE `limits_bot`
  ADD PRIMARY KEY (`bot_label`),
  ADD KEY `idx_mode` (`mode`);

--
-- فهارس للجدول `limits_global`
--
ALTER TABLE `limits_global`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_mode` (`mode`);

--
-- فهارس للجدول `limits_override`
--
ALTER TABLE `limits_override`
  ADD PRIMARY KEY (`account_id`),
  ADD KEY `idx_mode` (`mode`);

--
-- فهارس للجدول `limit_bans`
--
ALTER TABLE `limit_bans`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_account_bot_ban` (`user_id`,`account_id`,`bot_label`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_account` (`account_id`),
  ADD KEY `idx_until` (`banned_until`),
  ADD KEY `idx_active_bans` (`banned_until`,`user_id`),
  ADD KEY `idx_bot_bans` (`bot_label`);

--
-- فهارس للجدول `limit_counters`
--
ALTER TABLE `limit_counters`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_account_bot` (`user_id`,`account_id`,`bot_label`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_account` (`account_id`),
  ADD KEY `idx_day_reset` (`day_reset_at`),
  ADD KEY `idx_week_reset` (`week_reset_at`),
  ADD KEY `idx_month_reset` (`month_reset_at`),
  ADD KEY `idx_user_account_day` (`user_id`,`account_id`,`day_used`),
  ADD KEY `idx_bot_counters` (`bot_label`);

--
-- فهارس للجدول `limit_messages`
--
ALTER TABLE `limit_messages`
  ADD PRIMARY KEY (`event`);

--
-- فهارس للجدول `message_templates`
--
ALTER TABLE `message_templates`
  ADD PRIMARY KEY (`key`);

--
-- فهارس للجدول `steam_accounts`
--
ALTER TABLE `steam_accounts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `account_name` (`account_name`);

--
-- فهارس للجدول `steam_requests`
--
ALTER TABLE `steam_requests`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_recent` (`bot_token`,`user_id`,`account_name`,`request_time`),
  ADD KEY `fk_requests_account` (`account_name`),
  ADD KEY `idx_user_requests` (`user_id`,`request_time`);

--
-- فهارس للجدول `sub_bots`
--
ALTER TABLE `sub_bots`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `label` (`label`),
  ADD UNIQUE KEY `bot_token` (`bot_token`);

--
-- فهارس للجدول `system_logs`
--
ALTER TABLE `system_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_level_time` (`log_level`,`created_at`),
  ADD KEY `idx_component` (`component`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_component_time` (`component`,`created_at`),
  ADD KEY `idx_user_time` (`user_id`,`created_at`);

--
-- فهارس للجدول `vouchers`
--
ALTER TABLE `vouchers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`),
  ADD KEY `idx_code` (`code`),
  ADD KEY `idx_type` (`voucher_type`),
  ADD KEY `idx_active` (`current_uses`,`max_uses`),
  ADD KEY `idx_creator` (`created_by_user_id`);

--
-- فهارس للجدول `voucher_redemptions`
--
ALTER TABLE `voucher_redemptions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_voucher` (`voucher_code`),
  ADD KEY `idx_bot_token` (`bot_token`),
  ADD KEY `idx_redeemed_by` (`redeemed_by`),
  ADD KEY `idx_redeemed_at` (`redeemed_at`),
  ADD KEY `idx_redeemed_by_time` (`redeemed_by`,`redeemed_at`);

--
-- فهارس للجدول `voucher_usage`
--
ALTER TABLE `voucher_usage`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_voucher_code` (`voucher_code`),
  ADD KEY `idx_bot_id` (`bot_id`),
  ADD KEY `idx_used_at` (`used_at`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `account_groups`
--
ALTER TABLE `account_groups`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `allowed_users`
--
ALTER TABLE `allowed_users`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=282;

--
-- AUTO_INCREMENT for table `bot_managers`
--
ALTER TABLE `bot_managers`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `bot_message_templates`
--
ALTER TABLE `bot_message_templates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `broadcast_jobs`
--
ALTER TABLE `broadcast_jobs`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `broadcast_log`
--
ALTER TABLE `broadcast_log`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `control_sessions`
--
ALTER TABLE `control_sessions`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=29;

--
-- AUTO_INCREMENT for table `limits_global`
--
ALTER TABLE `limits_global`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `limit_bans`
--
ALTER TABLE `limit_bans`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `limit_counters`
--
ALTER TABLE `limit_counters`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `steam_accounts`
--
ALTER TABLE `steam_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=111;

--
-- AUTO_INCREMENT for table `steam_requests`
--
ALTER TABLE `steam_requests`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=86;

--
-- AUTO_INCREMENT for table `sub_bots`
--
ALTER TABLE `sub_bots`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=30;

--
-- AUTO_INCREMENT for table `system_logs`
--
ALTER TABLE `system_logs`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vouchers`
--
ALTER TABLE `vouchers`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `voucher_redemptions`
--
ALTER TABLE `voucher_redemptions`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `voucher_usage`
--
ALTER TABLE `voucher_usage`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

-- --------------------------------------------------------

--
-- Structure for view `active_bans`
--
DROP TABLE IF EXISTS `active_bans`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `active_bans`  AS SELECT `lb`.`id` AS `id`, `lb`.`user_id` AS `user_id`, `lb`.`account_id` AS `account_id`, `lb`.`banned_until` AS `banned_until`, `lb`.`reason` AS `reason`, `lb`.`created_at` AS `created_at`, `sa`.`account_name` AS `account_name`, timestampdiff(HOUR,current_timestamp(),`lb`.`banned_until`) AS `hours_remaining` FROM (`limit_bans` `lb` join `steam_accounts` `sa` on(`sa`.`id` = `lb`.`account_id`)) WHERE `lb`.`banned_until` > current_timestamp() ;

-- --------------------------------------------------------

--
-- Structure for view `current_usage`
--
DROP TABLE IF EXISTS `current_usage`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `current_usage`  AS SELECT `lc`.`id` AS `id`, `lc`.`user_id` AS `user_id`, `lc`.`account_id` AS `account_id`, `lc`.`day_used` AS `day_used`, `lc`.`week_used` AS `week_used`, `lc`.`month_used` AS `month_used`, `lc`.`day_reset_at` AS `day_reset_at`, `lc`.`week_reset_at` AS `week_reset_at`, `lc`.`month_reset_at` AS `month_reset_at`, `lc`.`updated_at` AS `updated_at`, `sa`.`account_name` AS `account_name`, CASE `current_day_used` ELSE `lc`.`day_used` AS `end` END FROM (`limit_counters` `lc` join `steam_accounts` `sa` on(`sa`.`id` = `lc`.`account_id`)) ;

--
-- القيود المفروضة على الجداول الملقاة
--

--
-- قيود الجداول `allowed_users`
--
ALTER TABLE `allowed_users`
  ADD CONSTRAINT `fk_allowed_users_bot` FOREIGN KEY (`bot_token`) REFERENCES `sub_bots` (`bot_token`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `bot_groups`
--
ALTER TABLE `bot_groups`
  ADD CONSTRAINT `bot_groups_ibfk_1` FOREIGN KEY (`bot_id`) REFERENCES `sub_bots` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `bot_groups_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `account_groups` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `bot_managers`
--
ALTER TABLE `bot_managers`
  ADD CONSTRAINT `fk_manager_bot` FOREIGN KEY (`bot_token`) REFERENCES `sub_bots` (`bot_token`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `bot_message_templates`
--
ALTER TABLE `bot_message_templates`
  ADD CONSTRAINT `bot_message_templates_ibfk_1` FOREIGN KEY (`bot_id`) REFERENCES `sub_bots` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `broadcast_log`
--
ALTER TABLE `broadcast_log`
  ADD CONSTRAINT `fk_broadcast_bot` FOREIGN KEY (`bot_token`) REFERENCES `sub_bots` (`bot_token`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `group_accounts`
--
ALTER TABLE `group_accounts`
  ADD CONSTRAINT `group_accounts_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `account_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `group_accounts_ibfk_2` FOREIGN KEY (`account_id`) REFERENCES `steam_accounts` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `limits_bot`
--
ALTER TABLE `limits_bot`
  ADD CONSTRAINT `limits_bot_ibfk_1` FOREIGN KEY (`bot_label`) REFERENCES `sub_bots` (`label`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `limits_override`
--
ALTER TABLE `limits_override`
  ADD CONSTRAINT `limits_override_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `steam_accounts` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `limit_bans`
--
ALTER TABLE `limit_bans`
  ADD CONSTRAINT `fk_bans_bot_label` FOREIGN KEY (`bot_label`) REFERENCES `sub_bots` (`label`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `limit_bans_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `steam_accounts` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `limit_counters`
--
ALTER TABLE `limit_counters`
  ADD CONSTRAINT `fk_counters_bot_label` FOREIGN KEY (`bot_label`) REFERENCES `sub_bots` (`label`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `limit_counters_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `steam_accounts` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `steam_requests`
--
ALTER TABLE `steam_requests`
  ADD CONSTRAINT `fk_requests_account` FOREIGN KEY (`account_name`) REFERENCES `steam_accounts` (`account_name`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_requests_bot` FOREIGN KEY (`bot_token`) REFERENCES `sub_bots` (`bot_token`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `voucher_redemptions`
--
ALTER TABLE `voucher_redemptions`
  ADD CONSTRAINT `fk_redemption_bot` FOREIGN KEY (`bot_token`) REFERENCES `sub_bots` (`bot_token`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_redemption_voucher` FOREIGN KEY (`voucher_code`) REFERENCES `vouchers` (`code`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- قيود الجداول `voucher_usage`
--
ALTER TABLE `voucher_usage`
  ADD CONSTRAINT `voucher_usage_ibfk_1` FOREIGN KEY (`voucher_code`) REFERENCES `vouchers` (`code`) ON DELETE CASCADE,
  ADD CONSTRAINT `voucher_usage_ibfk_2` FOREIGN KEY (`bot_id`) REFERENCES `sub_bots` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
